using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
		{
			QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}
			return objReturn;
		}
        public QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM GetItemByActivityId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ACTIVITYID)
        {
            QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM objReturn = null;
            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_getitemByActivityId(CURRENT_USER, CURRENT_REGISTRY_ID, ACTIVITYID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM objSave)
		{
			Int32? objReturn = objSave.ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CREATEDBY, objSave.Date_Fragment_Removal, objSave.Date_Lab_Received_Specimen, objSave.Duty_Location_Injury_Occurred, objSave.Fragment_1_Location, objSave.Fragment_2_Location, objSave.Fragment_3_Location, ref objReturn, objSave.Name_Referring_VAMC, objSave.Other_Location_Injury_Occurred, objSave.Provider_Fax_Number, objSave.Provider_Pager_Number, objSave.Provider_Telephone_Number, objSave.Referring_Facility_Contact_Name, objSave.Referring_Facility_Contact_Phone, objSave.Referring_Provider_Name, objSave.Referring_VAMC_City, objSave.Referring_VAMC_Country, objSave.Referring_VAMC_MailCode, objSave.Referring_VAMC_PostalCode, objSave.Referring_VAMC_State, objSave.Referring_VAMC_Street_Address1, objSave.Referring_VAMC_Street_Address2, objSave.Referring_VAMC_Street_Address3, objSave.Referring_VAMC_ZipPlus4, DateTime.Now, objSave.UPDATEDBY, objSave.WKF_CASE_ACTIVITY_ID);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
